UNIT StdRoutines;
INTERFACE
USES
{$L-}
{$U-}
     {$LOAD MQOTP.dumpfile}
       Memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf,
	 {$LOAD Globals.dumpfile}
     {$U Globals.p}  Globals,
	 {$LOAD}
	 {$U REvent.p} REvent;
{$U+}
{$SETC DebugFlg:=FALSE}

PROCEDURE PostHist(Subj,Objt,WhoElse: Integer);
PROCEDURE InitDialog(Guest,Host: Integer);
PROCEDURE EndDialog(Guest,Host: Integer);
PROCEDURE UnlockDoor(Where,How,Who: Integer);
PROCEDURE CalcTime(Who,VerbI: Integer);

IMPLEMENTATION
{********************************************************************************}
{$S Kathy}
{********************************************************************************}
PROCEDURE PostHist;
VAR
  i:	Integer;
BEGIN
  IF HistIndx<HistLeng THEN HistIndx:=HistIndx+1;
  {$IFC DebugFlg}
  IF HistIndx>=HistLeng THEN BEGIN MoveTo(480,40); DrawString('HistOvflw!'); END;
  {$ENDC}
  HstWrd1H^^[HistIndx]:=Subj;
  HstWrd3H^^[HistIndx]:=Objt;
  HstDateH^^[HistIndx]:=Day;
  HstTimeH^^[HistIndx]:=Time;
  FOR i:=1 TO 8 DO HstKnowH[HistIndx,i]:=FALSE;
  HstKnowH[HistIndx,Subj]:=TRUE;
  IF WhoElse>0 THEN HstKnowH[HistIndx,WhoElse]:=TRUE;
END;
{********************************************************************************}
PROCEDURE InitDialog;
VAR
  j:  		Integer;
BEGIN
  CharLocn[Guest]:=Host;
  Interloc[Guest]:=Host;
  Interloc[Host]:=Guest;
  DlogIndx[Host]:=0;
  DlogIndx[Guest]:=0;
  LoveMood[Guest]:=Love[Guest,Host];
  TrstMood[Guest]:=Trust[Guest,Host];
  FearMood[Guest]:=Fear[Guest,Host];
  LoveMood[Host]:=Love[Host,Guest];
  TrstMood[Host]:=Trust[Host,Guest];
  FearMood[Host]:=Fear[Host,Guest];
  DoorLock[Host]:=TRUE;
  ExecTime[Host]:=Time+3;
  Sentence[Host,VerbA]:=WPause;
  ExecTime[Guest]:=Time+1;
  Sentence[Guest,VerbA]:=WPause;
  FOR j:=1 TO SntcLeng DO LastSntc[Host,j]:=0;
  GuestFlg[Guest]:=TRUE;
  HelloFlg[Guest]:=FALSE;
  HelloFlg[Host]:=FALSE;
  Visits[Guest,Host]:=Visits[Guest,Host]+1;
  IF (Host=Player) OR (Guest=Player) THEN
    BEGIN
	  IF Host=Player THEN j:=Guest ELSE j:=Host;
	  LastLove:=Love[j,Player];
	  LastTrust:=Trust[j,Player];
	  LastFear:=Fear[j,Player];
	END;
END;
{********************************************************************************}
PROCEDURE UnlockDoor;
VAR
  i,j:	Integer;
  TempFlag:   Boolean;
BEGIN
  IF NOT DoorLock[Where] THEN
	BEGIN {let in anybody who's been waiting}
	  TempFlag:=FALSE;
      FOR i:=1 TO NumChars DO IF (CharLocn[i]=-Where) & NOT TempFlag THEN
		BEGIN
		  TempFlag:=TRUE;
		  InitDialog(i,Where);
		  IF How=HowDepart THEN
		    BEGIN
			  IF i=Player THEN
			    BEGIN
				  IF Random>0 THEN RandEvent(5,Who)
				  			  ELSE RandEvent(6,Where);
				END;
			  IF Who=Player THEN RandEvent(4,i);
			END;
		  IF i=Player 
		    THEN BEGIN StatDisp; Narrate(25+How,Who); END
		    ELSE 
			  BEGIN
			    IF CharLocn[i]=CharLocn[Player] THEN
				  BEGIN Narrate(11+How,i); END;
		      END;
		END;
	END;
END;
{********************************************************************************}
PROCEDURE EndDialog;
VAR
  i,j,OtherOne:  Integer;
{$IFC DebugFlg}
  LoclRect:    	Rect;
  LoclBits:    	ARRAY[1..10000] OF Integer;
  LoclBMap:    	BitMap;
{$ENDC}
BEGIN
{$IFC DebugFlg}
	{SetRect(LoclRect,0,20,128,340);
	LoclBMap.rowBytes:=16;
	LoclBMap.baseAddr:=@LoclBits;
	LoclBMap.bounds:=LoclRect;
	CopyBits(ScreenBits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
	FillRect(LoclRect,white);
	FOR i:=1 TO DlogIndx[Host] DO
	  BEGIN
	    MoveTo(2,i*28+6);
	    FOR j:=1 TO SntcLeng DO
		  BEGIN
		    MyWrite(DlogHist[Guest,i,j]); DrawString(' ' );
		  END;
		MoveTo(2,i*28+20);
	    FOR j:=1 TO SntcLeng DO
		  BEGIN
		    MyWrite(DlogHist[Host,i,j]); DrawString(' ' );
		  END;
	  END;
	REPEAT UNTIL Button;
	CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);}
  {$ENDC}
  OtherOne:=0;
  IF (Host=Player) THEN OtherOne:=Guest;
  IF (Guest=Player) THEN OtherOne:=Host;
  IF OtherOne>0 THEN
    BEGIN {test for advice #39}
	  IF LoveMood[OtherOne]<30 THEN DlogCount:=DlogCount+1;
	  IF (DlogCount>8) & (StoryParm[39]=1024) THEN StoryParm[39]:=32;
	END;
  CharLocn[Guest]:=0;
  Interloc[Guest]:=0;
  Interloc[Host]:=0;
  DoorLock[Host]:=FALSE;
  GuestFlg[Guest]:=FALSE;
  DlogIndx[Host]:=0;
  DlogIndx[Guest]:=0;
  FOR j:=1 TO SntcLeng DO LastSntc[Guest,j]:=0;
  UnlockDoor(Host,HowDepart,Guest);
END;
{********************************************************************************}
PROCEDURE CalcTime;
VAR
  i,j,TrialValue,x:	 Integer;
BEGIN
  TrialValue:=1;
  IF VerbI=WWait THEN TrialValue:=57;
  IF VerbI=WGo THEN
    BEGIN
	  TrialValue:=30;
	  FOR j:=1 TO SntcLeng DO LastSntc[Who,j]:=0;
	  CharLocn[Who]:=0;
	  Doorlock[Who]:=TRUE;
	END;	  
  IF (VerbI>=53) AND (VerbI<=55) THEN TrialValue:=1439-Time;
  ExecTime[Who]:=Time+TrialValue;
END;
{********************************************************************************}
END.